package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Kurumma_FL_door extends FrontDoor
{
	public Kurumma_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Kurumma front left door";

		value = 405;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.kurumma:0x000000CDr, "FL window", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000D5r, "L mirror", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CDr, "FL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D5r, "L mirror", actcolor, optical, power );
		}
	}
}
